unit Unit1;
{$O+}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
    atlagm : real=0;
    atlagc : real=0;

// talgosan fl msodpercig vrakoz eljrs
procedure Teszt;
begin
  Sleep(500);
end;

// Mandebrot halmazt megjelenteljrs
procedure Mandel(const frm : tform);
    var
       restep, imstep : extended;    // a vals s a kpzetes rsz lpshossza
       repart, impart : extended;    // a vals s a kpzetes rsz
       x,y            : integer;     // az aktulis kperny-koordintk
       maxx, maxy, maxc, cstep : integer; // grafikai jellemzk
       szin :integer;
      const
       restart = -2.267;  reend=1.0;  // a vals rsz rtkhatrai
       imstart = -1.125;              // a kpzetes rsz kezdrtke
       max : integer = 1600;          // a maximlis itercis mlysg
       mag = 1;                       // magnifikcis tnyez
       szinek:array[0..15] of tcolor =(
                                       clblack, clNavy , clGreen ,clTeal, clMaroon,
                                       clPurple,  clOlive, clSilver,
                                       clGray, clblue, clLime,
                                       clAqua, clRed, clFuchsia, clYellow, clWhite
                                       );

    // fggvny az iterci elvgzsre
    function  iterate(re,im : extended): integer;
    var
       x,y,x2,y2 : extended;
       k: integer;
    begin
      x:=0; y:=0; x2:=y; y2:=0; k:=0;
      repeat
        y:=2*x*y+im;
        x:=x2-y2+re;
        x2:=sqr(x);
        y2:=sqr(y);
        inc(k);
      until (x2+y2 > 4) or (k>=max);
      iterate:=k;
    end;

    // fggvny a kr/ciklois teszt elvgzsre
    function cycltest(zsx,re,im:extended):boolean;
    var zr,zs,imq:extended;
    begin
      imq := sqr(im);
      zr:=sqr(re) + imq;
      zs:=sqrt(zr-0.5*re+0.0625);
      if (16.0*zr*zs > 5*zs-4*re+1) and
         (sqr(re+1)+imq>0.0625)  then cycltest:=true
                                 else cycltest:=false;
    end;

begin
    // indtsi paramterek belltsa
    maxx:=frm.clientwidth;
    maxy:=frm.clientheight;
    maxc:=15+1; cstep:=max div maxc;
    restep:=(reend-restart) /maxx;
    imstep:=restep;

    // az iterci indtsa
    y:=0;
    impart:=imstart;
    while y<=maxy do
    begin
      repart := restart;
      x:=0;
      while x<=maxx do
      begin
        if cycltest(0.0625,repart,impart)
           then szin:=iterate(repart,impart)
           else szin:=max;
        frm.canvas.pixels[x,y]:=szinek[(maxc*cstep-szin) mod 16];
        inc(x,mag);
        repart:=repart+restep*mag;
      end; { while x }
      inc(y,mag);
      impart:=impart+imstep*mag;
    end;  {while y}
end;

// A rajzols s idmrs gombnyomsra
procedure TForm1.Button1Click(Sender: TObject);
var
   start, vege :Tdatetime;
   h,p,mp,ms:word;
   ido : real;
begin
   Button1.enabled:=false;
   Button2.enabled:=false;
   refresh;
   caption:='Rajzol..';
   start:=time;      // A kezdeti idpont a time vltozbl
   Mandel(form1);    
   vege:=time;       // A vgzs idpontja a time vltozbl
   decodetime((vege-start),h,p,mp,ms);  // az id dekdolsa
   ido:=(mp*100+ms)/100;
   if (atlagm=0) then atlagm:=ido
                     else atlagm:=(atlagm+ido)/2;
   caption:='Mandelbrot id: '+floattostr(ido)+' mp (tlagid: '+floattostr(atlagm)+ ' mp).';
   Button1.enabled:=true;
   Button2.enabled:=true;
end;

// Teszt idmrs gombnyomsra
procedure TForm1.Button2Click(Sender: TObject);
var
   start, vege :Tdatetime;
   h,p,mp,ms:word;
   ido : real;
begin
   Button1.enabled:=false;
   Button2.enabled:=false;
   caption:='Fut..';
   start:=time;      // A kezdeti idpont a time vltozbl
   Teszt;
   vege:=time;       // A vgzs idpontja a time vltozbl
   decodetime((vege-start),h,p,mp,ms);  // az id dekdolsa
   ido:=(mp*100+ms)/100;
   if (atlagc=0) then atlagc:=ido
                     else atlagc:=(atlagc+ido)/2;
   caption:='Fl msodperces tesztid: '+floattostr(ido)+' mp (tlagid: '+floattostr(atlagc)+ ' mp).';
   Button1.enabled:=true;
   Button2.enabled:=true;
end;

// A form jramretezsnl trljk az talagot
procedure TForm1.FormResize(Sender: TObject);
begin
  caption:='Idtesztek';
  atlagm:=0;
  atlagc:=0;
  refresh;
end;

end.
